#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

long long *allSolutions; 
int solutionsCount = 0;   

void explorePaths(int N, int S, int mi[], int ai[], int li[], int ri[], long long currentSoldiers, int currentLevel) {
    if (currentLevel == N) {
        
        allSolutions[solutionsCount++] = currentSoldiers;
        return;
    }

    
    explorePaths(N, S, mi, ai, li, ri, currentSoldiers * mi[currentLevel], currentLevel + 1);

    
    explorePaths(N, S, mi, ai, li, ri, currentSoldiers + ai[currentLevel], currentLevel + 1);
}

int compare(const void *a, const void *b) {
    return (*(long long *)b - *(long long *)a);
}

int main() {
    int T;
    scanf("%d", &T);

    for (int t = 0; t < T; t++) {
        int N, S;
        scanf("%d %d", &N, &S);

        int mi[N], ai[N], li[N], ri[N];

        
        for (int i = 0; i < N; i++)
            scanf("%d", &mi[i]);

        
        for (int i = 0; i < N; i++)
            scanf("%d", &ai[i]);

        
        for (int i = 0; i < N; i++)
            scanf("%d", &li[i]);

        
        for (int i = 0; i < N; i++)
            scanf("%d", &ri[i]);

        allSolutions = (long long *)malloc(N * 2 * sizeof(long long)); 

       
        explorePaths(N, S, mi, ai, li, ri, S, 0);

        qsort(allSolutions, solutionsCount, sizeof(long long), compare); 

        int result = 0;

        
        for (int i = 0; i < solutionsCount; i++) {
            if (allSolutions[i] < li[N - 1] || allSolutions[i] > ri[N - 1]) {
                continue; 
            } else {
                printf("%lld\n", allSolutions[i]);
                result = 1;
                break;
            }
        }

        if (!result) {
            printf("nemoguce\n");
        }

        free(allSolutions); 
    }

    return 0;
}